/* File Name : API894.H
 -----------------------------------------------------------------------------
 : Purpose :                                                                 :
 :   This head file defines Application Programming Interface for Run-Time   :
 : Libraries which drives quad-lines telecommunication adapter - VP894.      :
 : Usage pre-caution :                                                       :
 :   Do not define any constants named HOST, LOCAL or _H2INC in your applic- :
 : ation before this head file is included, they are reserved for Eletech    :
 : internal firmware and device driver development. (_H2INC is pre-defined   :
 : by H2INC which is a utility found in Microsoft Macro Assembler version    :
 : 6.x package)                                                              :
 :   Copyright (c) 1993-1994, Eletech Enterprise. written by Shya-Lin Wang.  :
 ----------------------------------------------------------------------------*/
#ifndef __API894_H

#ifdef __cplusplus
extern "C" {
#endif

#if (_MSC_VER < 700)
#define __cdecl         _cdecl
#endif

#define MAX_ADAPTER_NUM         16
#define CH_PER_CARD             4

/* acceptable DTMFs' enable equates */
#define E_DTMF0                 0x0001
#define E_DTMF1                 0x0002
#define E_DTMF2                 0x0004
#define E_DTMF3                 0x0008
#define E_DTMF4                 0x0010
#define E_DTMF5                 0x0020
#define E_DTMF6                 0x0040
#define E_DTMF7                 0x0080
#define E_DTMF8                 0x0100
#define E_DTMF9                 0x0200
#define E_DTMFa                 0x0400
#define E_DTMFb                 0x0800
#define E_DTMFc                 0x1000
#define E_DTMFd                 0x2000
#define E_DTMF_ASTERISK         0x4000  /*   '*'   */
#define E_DTMF_POUND            0x8000  /*   '#'   */
#define E_ALL_DTMF              0xffff  /* '0'-'9', '*', '#', 'A'-'D' */
#define E_DIGITS                                           \
        (E_DTMF0 | E_DTMF1 | E_DTMF2 | E_DTMF3 | E_DTMF4 | \
         E_DTMF5 | E_DTMF6 | E_DTMF7 | E_DTMF8 | E_DTMF9)
#define E_EXCLUDE_ALPHA         (E_DIGITS | E_DTMF_ASTERISK | E_DTMF_POUND)

/* event types' equates */
#define EVT_EOP_NORMAL                       0x1
#define EVT_DTMF_INTERCEPT                   0x2
#define EVT_LINE_ROARING_REMOTE_HANG_UP      0x3
#define EVT_LINE_VOLT_REVERSE_REMOTE_HANG_UP 0x4
#define EVT_LINE_BUSY_REMOTE_HANG_UP         0x5
#define EVT_NO_DIAL_TONE                     0x6
#define EVT_CPM_COMPLETE                     0x7
#define EVT_TIME_OUT                         0x8
#define EVT_LINE_SILENT                      0x9
#define EVT_ENDOF_STOP                       0xe
#define EVT_INTRN_QUEUE_OVERFLOW             0xf
#define EVT_DETECT_RING                      0x10
#define EVT_LOCAL_PHONE_PICKED_UP            0x11
#define EVT_LOCAL_PHONE_HUNG_UP              0x12
#define EVT_DETECT_DTMF                      0x13
#define EVT_REPORT_ENERGY                    0x14
#define EVT_DISPOSE_PCM_DATA                 0x15
#define EVT_LEARN_PULSE_SUCCESS              0x16
#define EVT_DETECT_PULSE                     0x17
#define EVT_VP894_DEAD                       0x70
#define EVT_VP894_ALIVE                      0x71
#define EVT_PCMIO_ERROR                      0x80

/* error codes returned by API */
#define ERR894_INVALID_FUNC             0x1000
#define ERR894_INVALID_PARAM            0x1001
#define ERR894_INVALID_CHANNEL          0x1002
#define ERR894_CHANNEL_BUSY             0x1003
#define ERR894_NO_MORE_VOICE_DATA       0x1004
#define ERR894_EVENT_QUEUE_OVERFLOW     0x1005
#define ERR894_PCMIO_QUEUE_OVERFLOW     0x1006
#define ERR894_PCM_FILE_IO              0x1007
#define ERR894_TEXT_CONV_SPEECH         0x1009
#define ERR894_INVALID_VOICE_BANK       0x100a
#define ERR894_DRIVER_NOT_INSTALLED     0x1010
#define ERR894_INVALID_ADAPTER_NUMBER   0x1011

#pragma pack(1)
/* definition of signal duty duration */
typedef struct _tagDutyDuration {
                 unsigned Silence;
                 unsigned NoneSilence;
                 unsigned SilenceTolerance;
                 unsigned NoneSilenceTolerance;
               } typeDutyDuration;

/* definition of cadences */
#define MAX_WAVE_COUNT          6

typedef struct _tagCadence {
                 unsigned char    WaveCount : 3;
                 unsigned char    Type      : 1;
                 unsigned char              : 4;
                 unsigned char    RecognizeCycle;
                 typeDutyDuration Wave[MAX_WAVE_COUNT];
               } typeCadence;

enum _tagWaveType { CYCLIC_WAVE, NONE_CYCLIC_WAVE };

/* definition of cadence types */
typedef struct _tagCadenceType {
                 typeCadence Ring;
                 typeCadence Busy;
                 typeCadence InvalidNum;
                 typeCadence DialTone;
                 typeCadence UserDefined1;
                 typeCadence UserDefined2;
               } typeCadenceType;

/* definition for CPM parameters */
typedef struct _tagCPMParam {
                 typeCadenceType CentralOffice;
                 typeCadenceType PrivateSystem;
                 typeCadence     Beeper;
               } typeCPMParam;

/* define characteristic for busy signal caused by remote hung-up */
typedef struct _tagHungUpBusy {
                 int              Varieties;    /* less or equal to 5 */
                 typeDutyDuration Cadence[5];
               } typeHungUpBusy;

typedef struct _tagHungUpParam {
                 typeHungUpBusy Busy;
                 unsigned       MinBusyDuration;
                 unsigned       MinRoarDuration;
                 unsigned char  BusyThreshold;
                 unsigned char  RoarThreshold;
                 unsigned       MinSilentDuration;
                 unsigned char  SilentThreshold;
               } typeHungUpParam;

#ifdef IMPLEMENT_RHU_IGNORED_FACTOR
typedef struct tagRHUIgnoredFactor {
          unsigned char Peak;
          unsigned char Valley;
          unsigned      MinDuration;
        } typeRHUIgnoredFactor;
#endif

/* operation mode of call out */
#define CM_NO_DO_CPM                    1
#define CM_NO_WAIT_DIAL_TONE            2
#define CM_DETECT_INVALID_NUM           4
#define CM_DETECT_USER_DEFINED1         8
#define CM_DETECT_USER_DEFINED2         16

/* result of CPM (Call Progress Monitor) */
#define CPMR_NO_ANSWER                  0
#define CPMR_BUSY                       1
#define CPMR_INVALID_NUM                2
#define CPMR_USER_DEFINED1              4
#define CPMR_USER_DEFINED2              5
#define CPMR_NO_SIGNAL                  6
#define CPMR_ANSWER                     7
#define CPMR_NO_RINGBACK                8
#define CPMR_CALL_BEEPER_SUCCESS        9

/* periodic clock interval */
#define TICK_INTERVAL           8       /* unit of millisecond */
#define Second2Tick(Second)     ((long) Second * 1000 / TICK_INTERVAL)

/* channel control parameter block */
typedef struct _tagCPB {
#ifndef _H2INC
                 unsigned      DialMode                        : 1;
                 unsigned      LineToPBX                       : 1;
                 unsigned      TriggerMode                     : 1;
                 unsigned      DetectRoaringRemoteHangUp       : 1;
                 unsigned      DetectBusyRemoteHangUp          : 1;
                 unsigned      DetectRemoteHangUpWhenRecording : 1;
                 unsigned      DetectRemoteHangUpAlways        : 1;
                 unsigned      StopOperationRemoteHangUp       : 1;
                 unsigned      MonitorDTMF                     : 1;
                 unsigned      MonitorEnergy                   : 1;
                 unsigned      DetectVoltReverseRemoteHangUp   : 1;
                 unsigned      DetectSilentWhenRecording       : 1;
                 unsigned      LearnPulse                      : 1;
                 unsigned      MonitorPulse                    : 1;
                 unsigned                                      : 2;
#else /*
         The following are internal names for bit field, we have to use
         different names' declaration from API to recover assembler
         limitation on record declaration for total name length.
      */
                 unsigned      DialMode                        : 1;
                 unsigned      LineToPBX                       : 1;
                 unsigned      TriggerMode                     : 1;
                 unsigned      DetectRoaring                   : 1;
                 unsigned      DetectBusy                      : 1;
                 unsigned      DetectHangUpWhenRecording       : 1;
                 unsigned      DetectRemoteHangUpAlways        : 1;
                 unsigned      StopOperationRemoteHangUp       : 1;
                 unsigned      MonitorDTMF                     : 1;
                 unsigned      MonitorEnergy                   : 1;
                 unsigned      DetectVoltReverse               : 1;
                 unsigned      DetectSilentWhenRecording       : 1;
                 unsigned      LearnPulse                      : 1;
                 unsigned      MonitorPulse                    : 1;
                 unsigned                                      : 2;
#endif
                 unsigned      OffHookDelay;
                 unsigned      OnHookDelay;
                 unsigned      FlashTime;
                 unsigned      PulseMake;
                 unsigned      PulseBreak;
                 unsigned      PulsePostDigitPause;
                 unsigned      ToneDuration;
                 unsigned      InterTonePause;
                 unsigned char OutsideLineAccess;
                 unsigned char RingsToAnswer;
                 unsigned      WaitAnswerDuration;
                 unsigned      InterDigitPause;
                 unsigned      NoSignalTimeOut;
                 unsigned      MaxSilence;
                 unsigned      MaxRoarDuration;
                 char          PlayGain;
                 char          RecordGain;
                 unsigned char PlayMode;
                 unsigned char RecordMode;
                 unsigned char OffThreshold;
               } typeCPB;

enum _tagDialMode    { D_TONE, D_PULSE };
enum _tagTriggerMode { TRG_RING, TRG_LOCAL_PICK_UP };
enum _tagPlayMode {
       PM_HIGHER_SAMPLING,              /* 9.8 or 16 Kbps                    */
       PM_HIGHER_SAMPLING_ECHO_CANCEL,  /* 9.8 or 16 Kbps, echo cancellation */
       PM_LOWER_SAMPLING,               /* 8 or 4.9 Kbps                     */
       PM_LOWER_SAMPLING_ECHO_CANCEL    /* 8 or 4.9 Kbps,  echo cancellation */
     };
enum _tagRecordMode {
       RM_STANDARD_RATE,                /* 9.8 Kbps */
       RM_PREMIUM_RATE,                 /* 16  Kbps */
       RM_INTERMEDIATE_RATE,            /* 8   Kbps */
       RM_EXTENDED_RATE                 /* 4.9 Kbps */
     };

#ifndef _H2INC
/* definition for Event */
typedef struct _tagEvent {
                 unsigned char Issuer;
                 unsigned char Type;
                 unsigned      Data;
               } typeEvent;
#endif
#pragma pack()

#if !defined(HOST) && !defined(LOCAL)
int  __cdecl Init894(int *Install);
void __cdecl Close894(void);
int  __cdecl GetCtrlParam(int ChNum, typeCPB *CtrlParam);
int  __cdecl SetCtrlParam(int ChNum, typeCPB *CtrlParam);
int  __cdecl PickUp(int ChNum);
int  __cdecl HangUp(int ChNum);
int  __cdecl Flash(int ChNum);
int  __cdecl Play(int ChNum, int Handle, long Length, unsigned AcceptDTMF);
int  __cdecl Record(int ChNum, int Handle,
                    unsigned Length, unsigned AcceptDTMF);
int  __cdecl GetDTMF(int ChNum, char *Buffer,
                     unsigned Count, unsigned AcceptDTMF, unsigned ExitDTMF);
int  __cdecl FlushDTMF(int ChNum);
int  __cdecl Dial(int ChNum, char *TargetNum);
int  __cdecl GetEnergy(int ChNum, unsigned char *const Buffer);
int  __cdecl StopCh(int ChNum);
int  __cdecl GetEvent(typeEvent *EvtBuf);
int  __cdecl InsertEvent(typeEvent *EvtBuf);
void __cdecl FlushEvent(void);

/* new functions for version 2.x */
void __cdecl GetCPMParam(typeCPMParam *CPMParam);
int  __cdecl SetCPMParam(const typeCPMParam *CPMParam);
int  __cdecl CallLocal(int ChNum, const char *TargetNum, unsigned Mode);
int  __cdecl CallRemote(int ChNum, const char *TargetNum, unsigned Mode);
int  __cdecl CallBeeper(int ChNum, const char *TargetNum, const char *Message);
void __cdecl GetHungUpParam(typeHungUpParam *Param);
int  __cdecl SetHungUpParam(typeHungUpParam *Param);
int  __cdecl SetInterLink(int ChNum, int bConnect);
int  __cdecl CheckWhetherVP894StillAlive(int AdptrNum, unsigned EchoTimeOut);
int  __cdecl Big5ToSpeech(int ChNum, int Handle,
                          char *pBig5Text, unsigned AcceptDTMF);
#ifdef IMPLEMENT_RHU_IGNORED_FACTOR
void __cdecl GetRHUIgnoredFactor(typeRHUIgnoredFactor *rhuif);
int  __cdecl SetRHUIgnoredFactor(typeRHUIgnoredFactor *rhuif);
#endif
#endif

#ifdef __cplusplus
}
#endif

#define __API894_H
#endif
