/*----------------------------------------------------------------------------*/
/*  compile and link as follow :                                              */
/*                                                                            */
/*       cl b5speech api894s.lib                                                   */
/*                                                                            */
/*----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <dos.h>
#include <assert.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include "api894.h"

#define ERR_FILEIO      0x8000
#define FALSE           0
#define TRUE            !FALSE

// BIOS data
#define KEYBRD_BUF_HEAD         0x0000041a
#define KEYBRD_BUF_TAIL         0x0000041c
#define VIDEO_COLUMN            0x0000044a
#define MAXCOL()                *((int __far *) VIDEO_COLUMN)
#define Clear_Keybrd_Buf() \
        *((volatile int __far *) KEYBRD_BUF_HEAD) = \
        *((volatile int __far *) KEYBRD_BUF_TAIL)
#define Keybrd_Buf_Empty() \
        (*((volatile int __far *) KEYBRD_BUF_HEAD) == \
         *((volatile int __far *) KEYBRD_BUF_TAIL))

enum tagVisitorReceptionFlow {
       STEP_WAIT_INIT_ECHO,
       STEP_MONITOR_INBOUND_CALL,
       STEP_PLAY_GREETING,
       STEP_GET_CALLER_RESPONSE,
       STEP_BYE_BYE
     };

int Install[MAX_ADAPTER_NUM], ChStatusPos[MAX_ADAPTER_NUM * CH_PER_CARD][2];
int ChProc[MAX_ADAPTER_NUM * CH_PER_CARD], hVoiceBank = -1;
char PlayGain, RecordGain;
unsigned char OffThreshold;
typeCPB CtrlParam[MAX_ADAPTER_NUM * CH_PER_CARD];
char *pmptGreeting = "zn,oO޹qqPrܽd{,"
                     "Хѹqܫ@ܤTܱzJ";
char *pmptPoem[] = {
        "NUm,by_,OPڥ,۷Φӫ",
        "իұm,d@,⩤nڤ,wLUs",
        "븨Q,Tv,hĬ~Hsx,]bnȲ"
      };

void CommandLineParser(int isOption, char *Argument);
void DeployBulletinBoard(void);
void FlowManager(typeEvent *const pEvent);
void FatalError(int ErrorCode, ...);
int  Get894Event(typeEvent *const pEvtBuf);
void ShowChStatus(int ChNum, char *Action);
void SplitCommandLineArgument(void (*Parser)(int, char *));
void Scroll(int Row1, int Column1, int Row2, int Column2, int RowCount);
void SETPOS(int Row, int Column);

main()
{
  int Result, AdptrNum, ChNum, Inkey;
  typeEvent Event;

  SplitCommandLineArgument(CommandLineParser);
  if (hVoiceBank == -1 && _dos_open("voice.bnk", _O_RDONLY, &hVoiceBank) != 0)
    FatalError(ERR_FILEIO, _doserrno);
  if (Result = Init894(Install))
    FatalError(Result);
  atexit(Close894);
  DeployBulletinBoard();
  for (AdptrNum = 0; AdptrNum < MAX_ADAPTER_NUM; ++AdptrNum)
    if (Install[AdptrNum])
      for (ChNum = 0; ChNum < CH_PER_CARD; ++ChNum)
        if (Install[AdptrNum] & 1 << ChNum) {
          int GlobalChNum = AdptrNum * CH_PER_CARD + ChNum;
          if (Result = GetCtrlParam(GlobalChNum, &CtrlParam[GlobalChNum]))
            FatalError(Result);
          CtrlParam[GlobalChNum].TriggerMode = TRG_RING;
          CtrlParam[GlobalChNum].RingsToAnswer = 1;
          CtrlParam[GlobalChNum].InterDigitPause = Second2Tick(5);
          CtrlParam[GlobalChNum].PlayGain = PlayGain;
          CtrlParam[GlobalChNum].RecordGain = RecordGain;
          CtrlParam[GlobalChNum].OffThreshold = OffThreshold;
          if (Result = SetCtrlParam(GlobalChNum, &CtrlParam[GlobalChNum]))
            FatalError(Result);
        }
  Clear_Keybrd_Buf();
  while (1) {
    if (Get894Event(&Event))
      FlowManager(&Event);
    if (!Keybrd_Buf_Empty() && ((Inkey = _getch()) == 'q' || Inkey == 'Q'))
      break;
  }
  Clear_Keybrd_Buf();
}

extern int __argc;
extern char **__argv;
/*---------------------------------------------------------------------------*/
void SplitCommandLineArgument(void (*Parser)(int, char *))
{
  register char *Token, *CmdArg;
  int Count;

  for (Count = 0; Count < __argc; ++Count) {
    CmdArg = __argv[Count];
    while (Token = strtok(CmdArg, "/")) {
      if (Count || CmdArg == NULL)
        Parser(CmdArg == NULL || *CmdArg == '/', Token);
      CmdArg = NULL;
    }
  }
}

/*---------------------------------------------------------------------------*/
void CommandLineParser(int isOption, char *Argument)
{
  if (isOption)
    if (!strnicmp(Argument, "pg=", 3)) {
      if ((PlayGain = atoi(Argument + 3)) < -10 || PlayGain > 10)
        puts("valid value for play gain is from -10 to 10"), exit(0);
    }
    else if (!strnicmp(Argument, "rg=", 3)) {
      if ((RecordGain = atoi(Argument + 3)) < -10 || RecordGain > 10)
        puts("valid value for record gain is from -10 to 10"), exit(0);
    }
    else if (!strnicmp(Argument, "ot=", 3)) {
      if ((OffThreshold = atoi(Argument + 3)) > 15)
        puts("valid off-threshold setting is from 0 to 15"), exit(0);
    }
    else
      puts("invalid argument"), exit(0);
  else if (hVoiceBank == -1) {
    if (_dos_open(Argument, _O_RDONLY, &hVoiceBank) != 0)
      FatalError(ERR_FILEIO, _doserrno);
  }
  else
    puts("invalid argument"), exit(0);
}

/*---------------------------------------------------------------------------*/
int Get894Event(typeEvent *const pEvtBuf)
{
  register int Result;

  if (Result = GetEvent(pEvtBuf)) {
    assert(pEvtBuf->Type != EVT_INTRN_QUEUE_OVERFLOW);
    if (pEvtBuf->Type == EVT_PCMIO_ERROR)
      FatalError(pEvtBuf->Data == ERR894_TEXT_CONV_SPEECH ?
                 ERR894_TEXT_CONV_SPEECH : ERR894_PCM_FILE_IO, pEvtBuf);
  }
  return Result;
}

/*---------------------------------------------------------------------------*/
void FlowManager(typeEvent *const pEvent)
{
  static char Buffer[MAX_ADAPTER_NUM * CH_PER_CARD][2];
  int Result;

  switch (ChProc[pEvent->Issuer]) {
    case STEP_WAIT_INIT_ECHO :
      if (pEvent->Type == EVT_EOP_NORMAL) {
        ShowChStatus(pEvent->Issuer, "wait ring");
        ChProc[pEvent->Issuer] = STEP_MONITOR_INBOUND_CALL;
      }
      break;

    case STEP_MONITOR_INBOUND_CALL :
      if (pEvent->Type == EVT_DETECT_RING) {
        if (Result = PickUp(pEvent->Issuer))
          FatalError(Result, pEvent);
        ChProc[pEvent->Issuer] = STEP_PLAY_GREETING;
      }
      break;

    case STEP_PLAY_GREETING :
      if (pEvent->Type == EVT_EOP_NORMAL) {
        if (Result = Big5ToSpeech(pEvent->Issuer, hVoiceBank,
                                  pmptGreeting, E_DTMF1 | E_DTMF2 | E_DTMF3))
          FatalError(Result, pEvent);
        ShowChStatus(pEvent->Issuer, "play greet");
        ChProc[pEvent->Issuer] = STEP_GET_CALLER_RESPONSE;
      }
      break;

    case STEP_GET_CALLER_RESPONSE :
      if (pEvent->Type == EVT_EOP_NORMAL) {
        if (Result = GetDTMF(pEvent->Issuer, Buffer[pEvent->Issuer], 1,
                      E_DTMF1 | E_DTMF2 | E_DTMF3, E_DTMF1 | E_DTMF2 | E_DTMF3))
          FatalError(Result, pEvent);
        ShowChStatus(pEvent->Issuer, "get option");
      }
      else if (pEvent->Type == EVT_DTMF_INTERCEPT) {
        char *OutMsg = "say poem ";
        assert(pEvent->Data >= '1' && pEvent->Data <= '3');
        if (Result = Big5ToSpeech(pEvent->Issuer, hVoiceBank,
                                  pmptPoem[pEvent->Data - '1'], 0))
          FatalError(Result, pEvent);
        OutMsg[8] = pEvent->Data;
        ShowChStatus(pEvent->Issuer, OutMsg);
        ChProc[pEvent->Issuer] = STEP_BYE_BYE;
      }
      else if (pEvent->Type == EVT_TIME_OUT) {
        if (Result = HangUp(pEvent->Issuer))
          FatalError(Result, pEvent);
        ShowChStatus(pEvent->Issuer, "hang up");
        ChProc[pEvent->Issuer] = STEP_WAIT_INIT_ECHO;
      }
      break;

    case STEP_BYE_BYE :
      if (pEvent->Type == EVT_EOP_NORMAL) {
        if (Result = HangUp(pEvent->Issuer))
          FatalError(Result, pEvent);
        ShowChStatus(pEvent->Issuer, "hang up");
        ChProc[pEvent->Issuer] = STEP_WAIT_INIT_ECHO;
      }
      break;
  }
}

/*---------------------------------------------------------------------------*/
void FatalError(int ErrorCode, ...)
{
  static const char *const ErrMsg[] = {
         "function invalid",
         "parameter(s) passed to API is (are) invalid",
         "channel number specified is invalid",
         "channel %d is busy",
         "channel %d : no more voice data",
         "internal error : event queue overflow",
         "internal error : voice I/O queue overflow",
         "channel %d voice file I/O error, DOS error code is %d",
         "unknow error",
         "channel %d : Big 5 code to speech conversion encounter error",
         "voice bank is corrupt",
         "unknow error",
         "unknow error",
         "unknow error",
         "unknow error",
         "unknow error",
         "DRV894.EXE has not been installed",
         "adapter number specified is invalid"
       };

  va_list OptionArg;
  union {
    typeEvent *pEvt;
    int sword;
  } Arg;

  va_start(OptionArg, ErrorCode);
  Arg.pEvt = va_arg(OptionArg, typeEvent *);
  printf(ErrorCode == ERR_FILEIO ? "access file error, DOS error code is %d" :
                                   ErrMsg[ErrorCode - ERR894_INVALID_FUNC],
         ErrorCode == ERR_FILEIO ? Arg.sword : Arg.pEvt->Issuer, Arg.pEvt->Data);
  exit(0);
}

/*---------------------------------------------------------------------------*/
void DeployBulletinBoard()
{
  int ChNum, Count, ChCount = 0, AdptrNum = 0;

  Scroll(0, 0, 24, 80, 25);
  while (AdptrNum < MAX_ADAPTER_NUM) {
    if (Install[AdptrNum])
      for (Count = 0; Count < CH_PER_CARD; ++Count) {
        ChNum = AdptrNum * CH_PER_CARD + Count;
        if (ChCount < 32) {
          ChStatusPos[ChNum][0] = (ChCount / 4) * 3;
          ChStatusPos[ChNum][1] = ChCount % 4 * 20;
          SETPOS(ChStatusPos[ChNum][0], ChStatusPos[ChNum][1]);
          printf("chanel num : %02d", ChNum);
          SETPOS(ChStatusPos[ChNum][0] + 1, ChStatusPos[ChNum][1]);
          printf("status : ");
          ShowChStatus(ChNum, "hang up");
        }
        else
          ChStatusPos[ChNum][0] = ChStatusPos[ChNum][1] = -1;
        ++ChCount;
      }
    ++AdptrNum;
  }
}

/*---------------------------------------------------------------------------*/
void ShowChStatus(int ChNum, char *Action)
{
  if (ChStatusPos[ChNum][0] != -1) {
    Scroll(ChStatusPos[ChNum][0] + 1, ChStatusPos[ChNum][1] + 9,
           ChStatusPos[ChNum][0] + 1, ChStatusPos[ChNum][1] + 19, 1);
    SETPOS(ChStatusPos[ChNum][0] + 1, ChStatusPos[ChNum][1] + 9);
    printf("%s", Action);
  }
}

/*---------------------------------------------------------------------------*/
void Scroll(int Row1, int Column1, int Row2, int Column2, int RowCount)
{
  union REGS Reg;

  Reg.h.ah = 6;
  Reg.h.al = RowCount;
  Reg.h.bh = 7;
  Reg.h.ch = Row1;
  Reg.h.cl = Column1;
  Reg.h.dh = Row2;
  Reg.h.dl = Column2;
  int86(0x10, &Reg, &Reg);
}

/*---------------------------------------------------------------------------*/
#define VIDEO_ACTIVE_PAGE       0x00000462
#define GetActivePage()         *((volatile char __far *) VIDEO_ACTIVE_PAGE)
void SETPOS(int Row, int Column)
{
  union REGS Reg;

  Reg.h.ah = 2;
  Reg.h.bh = GetActivePage();
  Reg.h.dh = Row;
  Reg.h.dl = Column;
  int86(0x10, &Reg, &Reg);
}
