#include "fileio.ch"
#include "api894.ch"

/* visitor reception flow */
#define STEP_WAIT_INIT_ECHO             0
#define STEP_MONITOR_INBOUND_CALL       1
#define STEP_PLAY_GREETING              2
#define STEP_GET_CALLER_RESPONSE        3
#define STEP_GET_CALLER_RESPONSE1       4
#define STEP_BYE_BYE                    5

PUBLIC PlayGain := 0, RecordGain := 0, OffThreshold := 0, hVoiceBank := -1, ;
       pmptGreeting := ;
         "zn,oO޹qqPrܽd{,Хѹqܫ@ܤTܱzJ", ;
       pmptPoem := { ;
         "NUm,by_,OPڥ,۷Φӫ", ;
         "իұm,d@,⩤nڤ,wLUs", ;
         "븨Q,Tv,hĬ~Hsx,]bnȲ" ;
       }, ;
       Install[MAX_ADAPTER_NUM], ;
       ChStatusPos[MAX_ADAPTER_NUM * CH_PER_CARD][2], ;
       ChDTMFCount[MAX_ADAPTER_NUM * CH_PER_CARD], ;
       ChProc[MAX_ADAPTER_NUM * CH_PER_CARD], ;
       CtrlParam[MAX_ADAPTER_NUM * CH_PER_CARD][21]

PARAMETERS clParam1, clParam2, clParam3, clParam4
IF PCOUNT() > 4
  ? "only precedent 4 command line arguments will be evaluated"
ENDIF
IF clParam1 != NIL
  ParseParam(clParam1)
ENDIF
IF clParam2 != NIL
  ParseParam(clParam2)
ENDIF
IF clParam3 != NIL
  ParseParam(clParam3)
ENDIF
IF clParam4 != NIL
  ParseParam(clParam4)
ENDIF
main()

PROCEDURE main()
*{
  LOCAL Result, GlobalChNum, AdptrNum, ChNum, KeyValue, Event[3]

  IF hVoiceBank == -1 .AND. (hVoiceBank := FOPEN("voice.bnk", FO_READ)) == -1
    DosFileIOFault(-1, FERROR())
  ENDIF
  IF (Result := Init894(Install)) != 0
    VP894Fault(Result)
  ENDIF
  LayoutDeskTop()
  FOR AdptrNum = 0 TO MAX_ADAPTER_NUM - 1
    IF Install[AdptrNum + 1] != 0
      FOR ChNum = 0 TO CH_PER_CARD - 1
        IF IsChExist(AdptrNum, ChNum) == .T.
          GlobalChNum = AdptrNum * CH_PER_CARD + ChNum
          IF (Result := GetCtrlParam(GlobalChNum, ;
                                     CtrlParam[GlobalChNum + 1])) != 0
            VP894Fault(Result, GlobalChNum)
          ENDIF
          CtrlParam[GlobalChNum + 1][1] = 0
          CtrlParam[GlobalChNum + 1][11] = 1
          CtrlParam[GlobalChNum + 1][13] = Second2Tick(5)
          CtrlParam[GlobalChNum + 1][17] = PlayGain
          CtrlParam[GlobalChNum + 1][18] = RecordGain
          CtrlParam[GlobalChNum + 1][21] = OffThreshold
          IF (Result := SetCtrlParam(GlobalChNum, ;
                                     CtrlParam[GlobalChNum + 1])) != 0
            VP894Fault(Result, GlobalChNum)
          ENDIF
          ChProc[GlobalChNum + 1] = STEP_WAIT_INIT_ECHO
        ENDIF
      NEXT
    ENDIF
  NEXT
  CLEAR TYPEAHEAD
  DO WHILE .T.
    IF Get894Event(Event) != 0
      FlowManager(Event)
    ENDIF
    IF (KeyValue := INKEY()) == ASC("q") .OR. KeyValue == ASC("Q")
      EXIT
    ENDIF
  ENDDO
  CLEAR TYPEAHEAD
  Close894()
*}

/*---------------------------------------------------------------------------*/
PROCEDURE ParseParam(Param)
*{
  IF UPPER(LEFT(Param, 4)) == "/PG="
    IF (PlayGain := VAL(SUBSTR(Param, 5))) >= -10 .AND. PlayGain <= 10
      RETURN
    ENDIF
    ? "valid value for play gain is from -10 to 10"
  ELSEIF UPPER(LEFT(Param, 4)) == "/RG="
    IF (RecordGain := VAL(SUBSTR(Param, 5))) >= -10 .AND. RecordGain <= 10
      RETURN
    ENDIF
    ? "valid value for record gain is from -10 to 10"
  ELSEIF UPPER(LEFT(Param, 4)) == "/OT="
    IF (OffThreshold := VAL(SUBSTR(Param, 5))) >= 0 .AND. OffThreshold <= 15
      RETURN
    ENDIF
    ? "valid off-threshold setting is from 0 to 15"
  ELSEIF hVoiceBank == -1
    IF (hVoiceBank := FOPEN(Param, FO_READ)) == -1
      DosFileIOFault(-1, FERROR())
    ENDIF
    RETURN
  ELSE
    ? "command line argument", Param, "is invalid."
  ENDIF
  QUIT
*}

/*---------------------------------------------------------------------------*/
PROCEDURE FlowManager(pEvent)
*{
  LOCAL Result, Buffer

  DO CASE
    CASE ChProc[pEvent[1] + 1] = STEP_WAIT_INIT_ECHO
      IF pEvent[2] == EVT_EOP_NORMAL
        DisplayChStatus(pEvent[1], "wait ring")
        ChProc[pEvent[1] + 1] = STEP_MONITOR_INBOUND_CALL
      ENDIF

    CASE ChProc[pEvent[1] + 1] = STEP_MONITOR_INBOUND_CALL
      IF pEvent[2] == EVT_DETECT_RING
        IF (Result := PickUp(pEvent[1])) != 0
          VP894Fault(Result, pEvent[1])
        ENDIF
        ChProc[pEvent[1] + 1] = STEP_PLAY_GREETING
      ENDIF

    CASE ChProc[pEvent[1] + 1] = STEP_PLAY_GREETING
      IF pEvent[2] == EVT_EOP_NORMAL
        IF (Result := Big5ToSpeech(pEvent[1], hVoiceBank, pmptGreeting, ;
                                   E_DTMF1 + E_DTMF2 + E_DTMF3)) != 0
          VP894Fault(Result, pEvent[1])
        ENDIF
        DisplayChStatus(pEvent[1], "play greet")
        ChProc[pEvent[1] + 1] = STEP_GET_CALLER_RESPONSE
      ENDIF

    CASE ChProc[pEvent[1] + 1] = STEP_GET_CALLER_RESPONSE .OR. ;
         ChProc[pEvent[1] + 1] = STEP_GET_CALLER_RESPONSE1
      IF (pEvent[2] == EVT_EOP_NORMAL)
        IF (Result := GetDTMF(pEvent[1], 1, E_DTMF1 + E_DTMF2 + E_DTMF3, ;
                                            E_DTMF1 + E_DTMF2 + E_DTMF3)) != 0
          VP894Fault(Result, pEvent[1])
        ENDIF
        DisplayChStatus(pEvent[1], "get option")
        ChProc[pEvent[1] + 1] = STEP_GET_CALLER_RESPONSE1
      ELSEIF pEvent[2] == EVT_DTMF_INTERCEPT
        IF ChProc[pEvent[1] + 1] == STEP_GET_CALLER_RESPONSE1 .AND. ;
           (Result := ReadReceivedDTMF(pEvent[1], @Buffer)) != 0
          VP894Fault(Result, pEvent[1])
        ENDIF
        IF (Result := Big5ToSpeech(pEvent[1], hVoiceBank, ;
                                   pmptPoem[pEvent[3] - ASC("0")], 0)) != 0
          VP894Fault(Result, pEvent[1])
        ENDIF
        DisplayChStatus(pEvent[1], "say poem" + LTRIM(CHR(pEvent[3])))
        ChProc[pEvent[1] + 1] = STEP_BYE_BYE
      ELSEIF pEvent[2] == EVT_TIME_OUT
        IF (Result := ReadReceivedDTMF(pEvent[1], @Buffer)) != 0
          VP894Fault(Result, pEvent[1])
        ENDIF
        IF (Result := HangUp(pEvent[1])) != 0
          VP894Fault(Result, pEvent[1])
        ENDIF
        DisplayChStatus(pEvent[1], "hang up")
        ChProc[pEvent[1] + 1] = STEP_WAIT_INIT_ECHO
      ENDIF

    CASE ChProc[pEvent[1] + 1] = STEP_BYE_BYE
      IF pEvent[2] == EVT_EOP_NORMAL
        IF (Result := HangUp(pEvent[1])) != 0
          VP894Fault(Result, pEvent[1])
        ENDIF
        DisplayChStatus(pEvent[1], "hang up")
        ChProc[pEvent[1] + 1] = STEP_WAIT_INIT_ECHO
      ENDIF
  ENDCASE
*}

/*---------------------------------------------------------------------------*/
PROCEDURE DosFileIOFault(ChNum, ErrorCode)
*{
  CLS
  IF ChNum == -1
    ? "file I/O error, DOS error code is", LTRIM(STR(ErrorCode))
  ELSE
    ? "channel", LTRIM(STR(ChNum)), ;
      ": file I/O error, DOS error code is", LTRIM(STR(ErrorCode))
  ENDIF
  Close894()
  QUIT
*}
